﻿Public Class Quad
    Inherits Shape

    Private _Normal As Vector3 = Vector3.Backward
    Private _Up As Vector3 = Vector3.Up
    Private _DefaultDepth As Single = 1.0F
    
    Public TopLeft As Vector3
    Public BottomLeft As Vector3
    Public TopRight As Vector3
    Public BottomRight As Vector3

    Sub New(size As Vector3, normal As Vector3, up As Vector3)
        MyBase.New(size)
        Me._NumberOfTriangles = 2
        Me._Normal = normal
        Me._Up = up
        Me.CreateGeometry()
    End Sub

    Sub New(size As Vector3)
        Me.New(size, Vector3.Backward, Vector3.Up)
    End Sub

    Public ReadOnly Property Normal As Vector3
        Get
            Return Me._Normal
        End Get
    End Property

    Public ReadOnly Property Up As Vector3
        Get
            Return Me._Up
        End Get
    End Property

    Public ReadOnly Property Height As Single
        Get
            Return Me.Size.Y
        End Get
    End Property

    Public ReadOnly Property Width As Single
        Get
            Return Me.Size.X
        End Get
    End Property


    Public Overrides Sub CreateVectors()
        Dim left As Vector3 = Vector3.Cross(Me.Normal, Me.Up)
        Dim upperCenter As Vector3 = (Me.Up * Me.Height / 2)
        Me.TopLeft = upperCenter + (left * Me.Width / 2)
        Me.TopRight = upperCenter - (left * Me.Width / 2)
        Me.BottomLeft = Me.TopLeft - (Me.Up * Me.Height)
        Me.BottomRight = Me.TopRight - (Me.Up * Me.Height)
    End Sub

    Public Overrides Sub FillVerticesList()
        Me._VerticesList.Clear()
        Dim textureTopLeft As Vector2 = New Vector2(1.0F, 0.0F)
        Dim textureTopRight As Vector2 = New Vector2(0.0F, 0.0F)
        Dim textureBottomLeft As Vector2 = New Vector2(1.0F, 1.0F)
        Dim textureBottomRight As Vector2 = New Vector2(0.0F, 1.0F)
        Me._VerticesList.Add(New VertexPositionNormalTexture(Me.TopLeft, Me.Normal, textureTopLeft))
        Me._VerticesList.Add(New VertexPositionNormalTexture(Me.BottomLeft, Me.Normal, textureBottomLeft))
        Me._VerticesList.Add(New VertexPositionNormalTexture(Me.TopRight, Me.Normal, textureTopRight))
        Me._VerticesList.Add(New VertexPositionNormalTexture(Me.BottomLeft, Me.Normal, textureBottomLeft))
        Me._VerticesList.Add(New VertexPositionNormalTexture(Me.BottomRight, Me.Normal, textureBottomRight))
        Me._VerticesList.Add(New VertexPositionNormalTexture(Me.TopRight, Me.Normal, textureTopRight))
    End Sub

    Public Overrides Function GetBoundingBoxForObject(o As WorldObject) As Microsoft.Xna.Framework.BoundingBox
        Dim sizeVector As Vector3
        Dim oldSizeVector As Vector3 = o.Size
        If o.Size.Z = 0 Then
            sizeVector = New Vector3(o.Size.X, o.Size.Y, Me._DefaultDepth)
        Else
            sizeVector = o.Size
        End If
        Dim c As New Cube(sizeVector)
        Return c.GetBoundingBoxForObject(o, sizeVector)
    End Function

    Public Overloads Overrides Sub RotateVectors(o As Shape, deleg As Shape.RotationDeleg, degrees As Single)

    End Sub

    Public Overrides Sub Translate(translateMatrix As Microsoft.Xna.Framework.Matrix)

    End Sub
End Class
